#include <Python.h>
#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include "LPShid.h"
#define FALSE 0
#define TRUE !FALSE
#define VERBOSE 0
#define WRAPPERVERSION "0.3"

// A module that takes no arguments
static PyObject* LPS_module_print_hello_world(PyObject *self, PyObject *args)
{
  printf("LPS cpy: Hello World\r\n");
  Py_RETURN_NONE;
}

/* This is the Vaunix-specific stuff. */
//void fnLPS_Init(void);
// A module that takes no arguments
static PyObject* LPS_module_fnLPS_Init(PyObject *self, PyObject *args)
{
  fnLPS_Init();
  Py_RETURN_NONE;
}

//void fnLPS_SetTestMode(bool testmode);
static PyObject* LPS_module_fnLPS_SetTestMode(PyObject *self, PyObject *args)
{
  int n;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetTestMode cpy: arg 1 is devid %d\r\n", devid);
#endif
      fnLPS_SetTestMode(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetTestMode expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetTestMode expects one argument");
      return NULL;
  }
  Py_RETURN_NONE;
}

//int fnLPS_GetNumDevices();
// A module that takes no arguments
static PyObject* LPS_module_fnLPS_GetNumDevices(PyObject *self, PyObject *args)
{
  int n;
  n = fnLPS_GetNumDevices();
  return PyLong_FromLong(n);
}

//int fnLPS_GetDevInfo(DEVID *ActiveDevices)
static PyObject* LPS_module_fnLPS_GetDevInfo(PyObject *self, PyObject *args)
{
  int i, n, numElements, result;
  PyObject *listObj, *numObj;
  unsigned int cActiveDevices[MAXDEVICES];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) {
    /* argument 1 should be an list of integers */
    listObj = PyTuple_GetItem(args, 0);
    /* get the number of lines passed to us */
    numElements = PyList_Size(listObj);

    /* should raise an error here. */
    if (numElements < 0)   return NULL; /* Not a list */
    if (numElements > MAXDEVICES) numElements = MAXDEVICES; /* Limit the number of devices to match the MAXDEVICES */
#if VERBOSE
    printf("The list has %d elements\r\n", numElements);
#endif
    
    for (i=0; i<numElements; i++) {
      numObj = PyList_GetItem(listObj, i);
      cActiveDevices[i] = PyLong_AsUnsignedLong(PyNumber_Long(numObj));
#if VERBOSE
      printf("Before, element %d is %d\r\n", i, cActiveDevices[i]);
#endif
    }
    result = fnLPS_GetDevInfo(cActiveDevices);
    
    for (i=0; i<numElements; i++) {
      PyList_SetItem(listObj, i, Py_BuildValue("i", cActiveDevices[i]));
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetDevInfo expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLPS_GetModelName(DEVID deviceID, char *ModelName);
static PyObject* LPS_module_fnLPS_GetModelName(PyObject *self, PyObject *args)
{
  int n;
  unsigned int devid;
  PyObject *temp_p;
  char ModelName[64];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetModelName cpy: arg 1  is devid %d\r\n", devid);
#endif
      //result = fnLPS_GetModelName(i, ModelName);
      fnLPS_GetModelName(devid, ModelName);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetModelName expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetModelName expects one argument");
      return NULL;
  }
  return PyBytes_FromString(ModelName);
}


//int fnLPS_InitDevice(DEVID deviceID);
static PyObject* LPS_module_fnLPS_InitDevice(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("InitDevice cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_InitDevice(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_InitDevice expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_InitDevice expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLPS_CloseDevice(DEVID deviceID);
static PyObject* LPS_module_fnLPS_CloseDevice(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("CloseDevice cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_CloseDevice(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_CloseDevice expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_CloseDevice expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLPS_GetSerialNumber(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetSerialNumber(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetSerialNumber cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetSerialNumber(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetSerialNumber expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetSerialNumber expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLPS_GetDeviceStatus(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetDeviceStatus(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get dev status cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetDeviceStatus(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetDeviceStatus expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetDeviceStatus expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//LVSTATUS fnLPS_SetChannel(DEVID deviceID, int channel);
static PyObject* LPS_module_fnLPS_SetChannel(PyObject *self, PyObject *args)
{
  int n, result, channel;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetFrequency cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetChannel expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      channel = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is channel %d\r\n", channel);
#endif
      result = fnLPS_SetChannel(devid, channel);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetChannel expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetChannel expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetWorkingFrequency(DEVID deviceID, int frequency);
static PyObject* LPS_module_fnLPS_SetWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result, frequency;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetFrequency cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetWorkingFrequency expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      frequency = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is frequency %d\r\n", frequency);
#endif
      result = fnLPS_SetWorkingFrequency(devid, frequency);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetWorkingFrequency expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetWorkingFrequency expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetWorkingFrequency(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetFrequency cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetWorkingFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetWorkingFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetWorkingFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetMinWorkingFrequency(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetMinWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Minimum Frequency cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetMinWorkingFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMinWorkingFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMinWorkingFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetWorkingFrequency(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetMaxWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Max Frequency cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetMaxWorkingFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMaxWorkingFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMaxWorkingFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetPhaseAngle(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetPhaseAngle(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Phase Angle cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetPhaseAngle(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetPhaseAngle expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetPhaseAngle expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetRampStart(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetRampStart(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Ramp Start cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetRampStart(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetRampStart expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetRampStart expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetRampEnd(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetRampEnd(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Ramp End cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetRampEnd(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetRampEnd expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetRampEnd expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetDwellTime(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetDwellTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetDwellTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetDwellTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetDwellTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetDwellTimeTwo(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetDwellTimeTwo(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Dwell time two cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetDwellTimeTwo(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetDwellTimeTwo expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetDwellTimeTwo expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetIdleTime(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetIdleTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Idle time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetIdleTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetIdleTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetIdleTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetHoldTime(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetHoldTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get hold time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetHoldTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetHoldTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetHoldTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetPhaseAngleStep(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetPhaseAngleStep(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Phase Angle step cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetPhaseAngleStep(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetPhaseAngleStep expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetPhaseAngleStep expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetPhaseAngleStepTwo(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetPhaseAngleStepTwo(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get PhaseAngle step two cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetPhaseAngleStepTwo(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetPhaseAngleStepTwo expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetPhaseAngleStepTwo expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetRF_On(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetRF_On(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get RF On cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetRF_On(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetRF_On expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetRF_On expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetProfileElement(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetProfileElement(PyObject *self, PyObject *args)
{
  int n, result, index;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
	  temp_p = PyTuple_GetItem(args, 1);
	  index = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile Element cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetProfileElement(devid, index);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileElement expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileElement expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}
//int fnLPS_GetProfileCount(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetProfileCount(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile count cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetProfileCount(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileCount expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileCount expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetProfileDwellTime(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetProfileDwellTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetProfileDwellTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileDwellTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileDwellTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetProfileIdleTime(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetProfileIdleTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile idle time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetProfileIdleTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileIdleTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileIdleTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetProfileIndex(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetProfileIndex(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile index cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetProfileIndex(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileIndex expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileIndex expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetMaxPhaseShift(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetMaxPhaseShift(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get max phase shift cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetMaxPhaseShift(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMaxPhaseShift expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMaxPhaseShift expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetMinPhaseShift(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetMinPhaseShift(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get min phase shift cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetMinPhaseShift(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMinPhaseShift expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMinPhaseShift expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetMinPhaseStep(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetMinPhaseStep(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get min phase angle step cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetMinPhaseStep(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMinPhaseStep expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetMinPhaseStep expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetFeatures(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetFeatures(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get features cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetFeatures(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetFeatures expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetFeatures expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetNumChannels(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetNumChannels(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Number of Channels cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetNumChannels(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetNumChannels expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetNumChannels expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLPS_GetProfileMaxLength(DEVID deviceID);
static PyObject* LPS_module_fnLPS_GetProfileMaxLength(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get profile max length cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_GetProfileMaxLength(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileMaxLength expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_GetProfileMaxLength expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//LVSTATUS fnLPS_SetPhaseAngle(DEVID deviceID, int phase);
static PyObject* LPS_module_fnLPS_SetPhaseAngle(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set phase angle cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngle expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is phase angle %d\r\n", data);
#endif
      result = fnLPS_SetPhaseAngle(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngle expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngle expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetPhaseAngleQ(DEVID deviceID, int phase, int channel)
static PyObject* LPS_module_fnLPS_SetPhaseAngleQ(PyObject *self, PyObject *args)
{
  int n, result, data, channel;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (3 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set phase angle cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleQ expects three integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
	  temp_p = PyTuple_GetItem(args, 2);
	  channel = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is phase angle %d\r\n", data);
	  printf("arg 3 is channel %d\r\n", channel);
#endif
      result = fnLPS_SetPhaseAngleQ(devid, data, channel);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleQ expects three integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleQ expects three arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetPhaseAngleMC(DEVID deviceID, int phase, unsigned long long chmask);
static PyObject* LPS_module_fnLPS_SetPhaseAngleMC(PyObject *self, PyObject *args)
{
  int n, result, phase;
  unsigned int devid;
  unsigned long long chmask;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (3 == n) {
    // arg 0: devid
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set phase angle MC: arg 1 is devid %u\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleMC expects three arguments (int, int, unsigned long long)");
      return NULL;
    }

    // arg 1: phase
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      phase = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is phase %d\r\n", phase);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleMC expects three arguments (int, int, unsigned long long)");
      return NULL;
    }

    // arg 2: chmask
    temp_p = PyTuple_GetItem(args, 2);
    if (1 == PyNumber_Check(temp_p)) {
      chmask = PyLong_AsUnsignedLongLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 3 is chmask %llu\r\n", chmask);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleMC expects three arguments (int, int, unsigned long long)");
      return NULL;
    }

    // Call the function
    result = fnLPS_SetPhaseAngleMC(devid, phase, chmask);

  } else {
    PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleMC expects three arguments (int, int, unsigned long long)");
    return NULL;
  }

  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetRampStart(DEVID deviceID, int rampstart);
static PyObject* LPS_module_fnLPS_SetRampStart(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set rampstart cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampStart expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is rampstart phase angle %d\r\n", data);
#endif
      result = fnLPS_SetRampStart(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampStart expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampStart expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetRampEnd(DEVID deviceID, int rampstop);
static PyObject* LPS_module_fnLPS_SetRampEnd(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set rampend cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampEnd expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is rampend phase angle %d\r\n", data);
#endif
      result = fnLPS_SetRampEnd(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampEnd expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampEnd expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetPhaseAngleStep(DEVID deviceID, int rampstop);
static PyObject* LPS_module_fnLPS_SetPhaseAngleStep(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set phase angle step cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleStep expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is phase angle step %d\r\n", data);
#endif
      result = fnLPS_SetPhaseAngleStep(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleStep expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleStep expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetPhaseAngleStepTwo(DEVID deviceID, int phasestep2);
static PyObject* LPS_module_fnLPS_SetPhaseAngleStepTwo(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set bi-directional phase angle step cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleStepTwo expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is bi-directional phase angle step %d\r\n", data);
#endif
      result = fnLPS_SetPhaseAngleStepTwo(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleStepTwo expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetPhaseAngleStepTwo expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetDwellTime(DEVID deviceID, int dwelltime);
static PyObject* LPS_module_fnLPS_SetDwellTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetDwellTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is dwell time %d\r\n", data);
#endif
      result = fnLPS_SetDwellTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetDwellTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetDwellTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetIdleTime(DEVID deviceID, int idletime);
static PyObject* LPS_module_fnLPS_SetIdleTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set idle time two cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetIdleTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is idle time two  %d\r\n", data);
#endif
      result = fnLPS_SetIdleTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetIdleTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetIdleTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetHoldTime(DEVID deviceID, int holdtime);
static PyObject* LPS_module_fnLPS_SetHoldTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set hold time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetHoldTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is hold time %d\r\n", data);
#endif
      result = fnLPS_SetHoldTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetHoldTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetHoldTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetDwellTimeTwo(DEVID deviceID, int dwelltime2);
static PyObject* LPS_module_fnLPS_SetDwellTimeTwo(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set dwell time two cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetDwellTimeTwo expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is dwell time two  %d\r\n", data);
#endif
      result = fnLPS_SetDwellTimeTwo(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetDwellTimeTwo expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetDwellTimeTwo expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetProfileElement(DEVID deviceID, int index, int phase);
static PyObject* LPS_module_fnLPS_SetProfileElement(PyObject *self, PyObject *args)
{
  int n, result, data, phase;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (3 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile element cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileElement expects three integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
	  temp_p = PyTuple_GetItem(args, 2);
	  phase = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is index %d\r\n", data);
	  printf("arg 3 is phase %d\r\n", phase);
#endif
      result = fnLPS_SetProfileElement(devid, data, phase);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileElement expects three integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileElement expects three arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetProfileCount(DEVID deviceID, int profilecount);
static PyObject* LPS_module_fnLPS_SetProfileCount(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile count cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileCount expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile count %d\r\n", data);
#endif
      result = fnLPS_SetProfileCount(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileCount expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileCount expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetProfileIdleTime(DEVID deviceID, int idletime);
static PyObject* LPS_module_fnLPS_SetProfileIdleTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile idle time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileIdleTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile idle time %d\r\n", data);
#endif
      result = fnLPS_SetProfileIdleTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileIdleTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileIdleTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetProfileDwellTime(DEVID deviceID, int dwelltime);
static PyObject* LPS_module_fnLPS_SetProfileDwellTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileDwellTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile dwell time %d\r\n", data);
#endif
      result = fnLPS_SetProfileDwellTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileDwellTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetProfileDwellTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_StartProfile(DEVID deviceID, int mode);
static PyObject* LPS_module_fnLPS_StartProfile(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile mode cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartProfile expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile mode %d\r\n", data);
#endif
      result = fnLPS_StartProfile(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartProfile expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartProfile expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_StartProfileMC(DEVID deviceID, int mode, int chmask, bool delayed);
static PyObject* LPS_module_fnLPS_StartProfileMC(PyObject *self, PyObject *args)
{
  int n, result, mode, chmask, delayed;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (4 == n) { 
    // arg 0: devid
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile mode cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "fnLPS_StartProfileMC expects four integer arguments");
      return NULL;
    }

    // arg 1: mode
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      mode = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile mode %d\r\n", mode);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "fnLPS_StartProfileMC expects four integer arguments");
      return NULL;
    }

    // arg 2: chmask
    temp_p = PyTuple_GetItem(args, 2);
    if (1 == PyNumber_Check(temp_p)) {
      chmask = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 3 is chmask %d\r\n", chmask);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "fnLPS_StartProfileMC expects four integer arguments");
      return NULL;
    }

    // arg 3: delayed (bool)
    temp_p = PyTuple_GetItem(args, 3);
    if (1 == PyNumber_Check(temp_p)) {
      delayed = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 4 is delayed %d\r\n", delayed);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "fnLPS_StartProfileMC expects four integer arguments");
      return NULL;
    }

    // Call the new function
    result = fnLPS_StartProfileMC(devid, mode, chmask, delayed ? true : false);

  } else {
      PyErr_SetString(PyExc_ValueError, "fnLPS_StartProfileMC expects four arguments");
      return NULL;
  }

  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetRFOn(DEVID deviceID, bool on);
static PyObject* LPS_module_fnLPS_SetRFOn(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set rf state cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRFOn expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is rf state %d\r\n", data);
#endif
      result = fnLPS_SetRFOn(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRFOn expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRFOn expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetRampDirection(DEVID deviceID, bool up);
static PyObject* LPS_module_fnLPS_SetRampDirection(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp direction cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampDirection expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp direction %d\r\n", data);
#endif
      result = fnLPS_SetRampDirection(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampDirection expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampDirection expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SetRampMode(DEVID deviceID, bool mode;
static PyObject* LPS_module_fnLPS_SetRampMode(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp mode cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampMode expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp mode %d\r\n", data);
#endif
      result = fnLPS_SetRampMode(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampMode expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampMode expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_SetRampBidirectional(DEVID deviceID, bool bidir_enable)
static PyObject* LPS_module_fnLPS_SetRampBidirectional(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp bi-drectional cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampBidirectional expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp bi-drectional %d\r\n", data);
#endif
      result = fnLPS_SetRampBidirectional(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampBidirectional expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SetRampBidirectional expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_StartRamp(DEVID deviceID, bool go)
static PyObject* LPS_module_fnLPS_StartRamp(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp control cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRamp expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp control %d\r\n", data);
#endif
      result = fnLPS_StartRamp(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRamp expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRamp expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLPS_StartRampMC(DEVID deviceID, int mode, int chmask, bool deferred);
static PyObject* LPS_module_fnLPS_StartRampMC(PyObject *self, PyObject *args)
{
  int n, result, mode, chmask, deferred;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (4 == n) {
    // arg 0: devid
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRampMC expects four integer arguments");
      return NULL;
    }

    // arg 1: mode
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      mode = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is mode %d\r\n", mode);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRampMC expects four integer arguments");
      return NULL;
    }

    // arg 2: chmask
    temp_p = PyTuple_GetItem(args, 2);
    if (1 == PyNumber_Check(temp_p)) {
      chmask = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 3 is chmask %d\r\n", chmask);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRampMC expects four integer arguments");
      return NULL;
    }

    // arg 3: deferred (bool)
    temp_p = PyTuple_GetItem(args, 3);
    if (1 == PyNumber_Check(temp_p)) {
      deferred = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 4 is deferred %d\r\n", deferred);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRampMC expects four integer arguments");
      return NULL;
    }

    // call the new function
    result = fnLPS_StartRampMC(devid, mode, chmask, deferred ? true : false);

  } else {
    PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_StartRampMC expects four arguments");
    return NULL;
  }

  return PyLong_FromLong(result);
}

// LVSTATUS fnLPS_SaveSettings(DEVID deviceID)
static PyObject* LPS_module_fnLPS_SaveSettings(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set save settings cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLPS_SaveSettings(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SaveSettings expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_SaveSettings expects one arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//char* fnLPS_perror(LVSTATUS status);
static PyObject* LPS_module_fnLPS_perror(PyObject *self, PyObject *args)
{
  unsigned int i, n;
  PyObject *temp_p;
  char errorstring[64];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      i = 0xFFFFFFFF & PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("perror cpy: arg 1 is %x\r\n", i);
#endif
      sprintf(errorstring,"%s",fnLPS_perror(i));
    } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_fnLPS_perror expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LPS_module.fnLPS_fnLPS_perror expects one argument");
      return NULL;
  }
  return PyBytes_FromString(errorstring);
}

//int fnLPS_GetLibVersion(void);
static PyObject* LPS_module_fnLPS_GetLibVersion(PyObject *self, PyObject *args)
{
  int version = fnLPS_GetLibVersion();
  return PyLong_FromLong(version);
}

static PyObject* LPS_module_WrapperVersion(PyObject *self, PyObject *args)
{
  return PyBytes_FromString(WRAPPERVERSION);
}
//Method definition object for this extension, these argumens mean:
//ml_name: The name of the method
//ml_meth: Function pointer to the method implementation
//ml_flags: Flags indicating special features of this method, such as
//          accepting arguments, accepting keyword arguments, being a
//          class method, or being a static method of a class.
//ml_doc:  Contents of this method's docstring
static PyMethodDef LPS_module_methods[] = { 
    {   
        "print_hello_world",
        LPS_module_print_hello_world,
        METH_NOARGS,
        "Print 'hello world' from a method defined in a C extension."
    },  
    {   
        "fnLPS_Init",
        LPS_module_fnLPS_Init,
        METH_NOARGS,
        "Set up the LPS device"
    },  
    {   
        "fnLPS_SetTestMode",
        LPS_module_fnLPS_SetTestMode,
        METH_VARARGS,
        "Set test mode if desired"
    },  
    {   
        "fnLPS_GetNumDevices",
        LPS_module_fnLPS_GetNumDevices,
        METH_NOARGS,
        "Return the number of LPS devices"
    },  
    {   
        "fnLPS_GetDevInfo",
        LPS_module_fnLPS_GetDevInfo,
        METH_VARARGS,
        "Returns a list of active devices"
    },  
    {   
        "fnLPS_GetModelName",
        LPS_module_fnLPS_GetModelName,
        METH_VARARGS,
        "Returns the name of an LPS model"
    },  
    {   
        "fnLPS_InitDevice",
        LPS_module_fnLPS_InitDevice,
        METH_VARARGS,
        "Initializes an LPS device"
    },  
    {   
        "fnLPS_CloseDevice",
        LPS_module_fnLPS_CloseDevice,
        METH_VARARGS,
        "Closes an LPS device"
    },  
    {   
        "fnLPS_GetSerialNumber",
        LPS_module_fnLPS_GetSerialNumber,
        METH_VARARGS,
        "Returns the serial of an LPS device"
    },  
    {   
        "fnLPS_GetDeviceStatus",
        LPS_module_fnLPS_GetDeviceStatus,
        METH_VARARGS,
        "Returns the status of an LPS device"
    }, 
    {   
        "fnLPS_SetChannel",
        LPS_module_fnLPS_SetChannel,
        METH_VARARGS,
        "Sets the Channel on an LPS device"
    },  
    {   
        "fnLPS_SetWorkingFrequency",
        LPS_module_fnLPS_SetWorkingFrequency,
        METH_VARARGS,
        "Sets the Working Frequency on an LPS device"
    },  
    {   
        "fnLPS_GetWorkingFrequency",
        LPS_module_fnLPS_GetWorkingFrequency,
        METH_VARARGS,
        "Returns the current working frequency"
    },  
    {   
        "fnLPS_GetMinWorkingFrequency",
        LPS_module_fnLPS_GetMinWorkingFrequency,
        METH_VARARGS,
        "Returns the minimum working frequency"
    },
    {   
        "fnLPS_GetMaxWorkingFrequency",
        LPS_module_fnLPS_GetMaxWorkingFrequency,
        METH_VARARGS,
        "Returns the maximum working frequency"
    },
    {   
        "fnLPS_GetPhaseAngle",
        LPS_module_fnLPS_GetPhaseAngle,
        METH_VARARGS,
        "Returns the current phase angle"
    }, 
    {   
        "fnLPS_GetRampStart",
        LPS_module_fnLPS_GetRampStart,
        METH_VARARGS,
        "Returns the ramp start phase angle data"
    }, 
    {   
        "fnLPS_GetRampEnd",
        LPS_module_fnLPS_GetRampEnd,
        METH_VARARGS,
        "Returns the ramp end phase angle data"
    }, 
    {   
        "fnLPS_GetDwellTime",
        LPS_module_fnLPS_GetDwellTime,
        METH_VARARGS,
        "Returns the dwell time data"
    }, 
    {   
        "fnLPS_GetDwellTimeTwo",
        LPS_module_fnLPS_GetDwellTimeTwo,
        METH_VARARGS,
        "Returns the dwell time two data"
    }, 
    {   
        "fnLPS_GetIdleTime",
        LPS_module_fnLPS_GetIdleTime,
        METH_VARARGS,
        "Returns the idle time"
    }, 
    {   
        "fnLPS_GetHoldTime",
        LPS_module_fnLPS_GetHoldTime,
        METH_VARARGS,
        "Returns the hold time"
    }, 
    {   
        "fnLPS_GetPhaseAngleStep",
        LPS_module_fnLPS_GetPhaseAngleStep,
        METH_VARARGS,
        "Returns the phase angle step size"
    }, 	
    {   
        "fnLPS_GetPhaseAngleStepTwo",
        LPS_module_fnLPS_GetPhaseAngleStepTwo,
        METH_VARARGS,
        "Returns the phase angle step size two"
    }, 
    {   
        "fnLPS_GetProfileElement",
        LPS_module_fnLPS_GetProfileElement,
        METH_VARARGS,
        "Returns the profile element of the index"
    }, 
    {   
        "fnLPS_GetProfileCount",
        LPS_module_fnLPS_GetProfileCount,
        METH_VARARGS,
        "Returns the profile count data"
    }, 
    {   
        "fnLPS_GetProfileDwellTime",
        LPS_module_fnLPS_GetProfileDwellTime,
        METH_VARARGS,
        "Returns the profile dwell time"
    }, 
    {   
        "fnLPS_GetProfileIdleTime",
        LPS_module_fnLPS_GetProfileIdleTime,
        METH_VARARGS,
        "Returns the profile idle time"
    }, 
    {   
        "fnLPS_GetProfileIndex",
        LPS_module_fnLPS_GetProfileIndex,
        METH_VARARGS,
        "Returns the profile index"
    }, 
    {   
        "fnLPS_GetMaxPhaseShift",
        LPS_module_fnLPS_GetMaxPhaseShift,
        METH_VARARGS,
        "Returns the max phase shift"
    }, 
    {   
        "fnLPS_GetMinPhaseShift",
        LPS_module_fnLPS_GetMinPhaseShift,
        METH_VARARGS,
        "Returns the minimum phase shift"
    }, 
    {   
        "fnLPS_GetMinPhaseStep",
        LPS_module_fnLPS_GetMinPhaseStep,
        METH_VARARGS,
        "Returns the minimum phase angle step size"
    }, 
    {   
        "fnLPS_GetFeatures",
        LPS_module_fnLPS_GetFeatures,
        METH_VARARGS,
        "Returns the current features"
    }, 
    {   
        "fnLPS_GetNumChannels",
        LPS_module_fnLPS_GetNumChannels,
        METH_VARARGS,
        "Returns the number of channels"
    }, 
    {   
        "fnLPS_GetProfileMaxLength",
        LPS_module_fnLPS_GetProfileMaxLength,
        METH_VARARGS,
        "Returns the profile max length"
    }, 
    {   
        "fnLPS_SetPhaseAngle",
        LPS_module_fnLPS_SetPhaseAngle,
        METH_VARARGS,
        "Sets the phase angle to an LPS device"
    },  
    {   
        "fnLPS_SetPhaseAngleQ",
        LPS_module_fnLPS_SetPhaseAngleQ,
        METH_VARARGS,
        "Sets the phase angle of channel to an LPS device"
    },  
    {   
        "fnLPS_SetPhaseAngleMC",
        LPS_module_fnLPS_SetPhaseAngleMC,
        METH_VARARGS,
        "Sets the phase angle of multiple channels to an LPS device"
    },  
    {   
        "fnLPS_SetRampStart",
        LPS_module_fnLPS_SetRampStart,
        METH_VARARGS,
        "Sets the ramp start phase angle to an LPS device"
    },  
    {   
        "fnLPS_SetRampEnd",
        LPS_module_fnLPS_SetRampEnd,
        METH_VARARGS,
        "Sets the ramp stop phase angle to an LPS device"
    },  
    {   
        "fnLPS_SetPhaseAngleStep",
        LPS_module_fnLPS_SetPhaseAngleStep,
        METH_VARARGS,
        "Sets the phase angle step size to an LPS device"
    },  
    {   
        "fnLPS_SetPhaseAngleStepTwo",
        LPS_module_fnLPS_SetPhaseAngleStepTwo,
        METH_VARARGS,
        "Sets the bidirectional phase angle step size to an LPS device"
    },  
    {   
        "fnLPS_SetDwellTime",
        LPS_module_fnLPS_SetDwellTime,
        METH_VARARGS,
        "Sets the dwell time to on an LPS device"
    }, 
    {   
        "fnLPS_SetDwellTimeTwo",
        LPS_module_fnLPS_SetDwellTimeTwo,
        METH_VARARGS,
        "Sets the bi-directional dwell time to an LPS device"
    },  
    {   
        "fnLPS_SetIdleTime",
        LPS_module_fnLPS_SetIdleTime,
        METH_VARARGS,
        "Sets the idle time to an LPS device"
    },  
    {   
        "fnLPS_SetHoldTime",
        LPS_module_fnLPS_SetHoldTime,
        METH_VARARGS,
        "Sets the hold time to an LPS device"
    },  
    {   
        "fnLPS_SetProfileElement",
        LPS_module_fnLPS_SetProfileElement,
        METH_VARARGS,
        "Sets the profile element to an LPS device"
    },  
    {   
        "fnLPS_SetProfileCount",
        LPS_module_fnLPS_SetProfileCount,
        METH_VARARGS,
        "Sets the profile count to an LPS device"
    },  
    {   
        "fnLPS_SetProfileIdleTime",
        LPS_module_fnLPS_SetProfileIdleTime,
        METH_VARARGS,
        "Sets the profile idle time to an LPS device"
    },  
    {   
        "fnLPS_SetProfileDwellTime",
        LPS_module_fnLPS_SetProfileDwellTime,
        METH_VARARGS,
        "Sets the profile dwell time to an LPS device"
    },  
    {   
        "fnLPS_StartProfile",
        LPS_module_fnLPS_StartProfile,
        METH_VARARGS,
        "Sets the profile mode to an LPS device"
    },
    {   
        "fnLPS_StartProfileMC",
        LPS_module_fnLPS_StartProfileMC,
        METH_VARARGS,
        "Sets the profile control mode to an LPS device for multiple channels"
    },  	
    {   
        "fnLPS_SetRampDirection",
        LPS_module_fnLPS_SetRampDirection,
        METH_VARARGS,
        "Sets the ramp direction to an LPS device"
    },  
    {   
        "fnLPS_SetRampMode",
        LPS_module_fnLPS_SetRampMode,
        METH_VARARGS,
        "Sets the ramp mode to an LPS device"
    },  
    {   
        "fnLPS_SetRampBidirectional",
        LPS_module_fnLPS_SetRampBidirectional,
        METH_VARARGS,
        "Sets the bi-directional ramp mode to an LPS device"
    },  
    {   
        "fnLPS_StartRamp",
        LPS_module_fnLPS_StartRamp,
        METH_VARARGS,
        "Sets the ramp control mode to an LPS device"
    },  	
    {   
        "fnLPS_StartRampMC",
        LPS_module_fnLPS_StartRampMC,
        METH_VARARGS,
        "Sets the ramp control mode to an LPS device for multiple channels"
    },  	
    {   
        "fnLPS_SaveSettings",
        LPS_module_fnLPS_SaveSettings,
        METH_VARARGS,
        "Sets the LPS save settings configuration"
    },  
    {   
        "fnLPS_perror",
        LPS_module_fnLPS_perror,
        METH_VARARGS,
        "Converts an LPS library error to a string"
    },  
    {   
        "fnLPS_GetLibVersion",
        LPS_module_fnLPS_GetLibVersion,
        METH_NOARGS,
        "Returns the LPS library version"
    },  
    {   
        "WrapperVersion",
        LPS_module_WrapperVersion,
        METH_NOARGS,
        "Returns the LPS library wrapper version"
    },  
    {NULL, NULL, 0, NULL}
};


//Module definition
//The arguments of this structure tell Python what to call your extension,
//what it's methods are and where to look for it's method definitions
static struct PyModuleDef LPS_module_definition = { 
    PyModuleDef_HEAD_INIT,
    "LPS_module",
    "A Python module for managing the Vaunix LPS series Phase Shifters.",
    -1, 
    LPS_module_methods
};

//Module initialization
//Python calls this function when importing your extension. It is important
//that this function is named PyInit_[[your_module_name]] exactly, and matches
//the name keyword argument in setup.py's setup() call.
PyMODINIT_FUNC PyInit_LPS_module(void)
{
    Py_Initialize();

    return PyModule_Create(&LPS_module_definition);
}

